﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;
using System.Data;

namespace AZVIC.Ei8htPOS.BAL
{


    [DataObjectAttribute()]
    public static class UserAccountBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static UserAccount GetItem(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            return UserAccountDB.GetItem(userAccountID, userName, password, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<UserAccount> GetList(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            return UserAccountDB.GetList(userAccountID, userName, password, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<UserAccount> GetOfflineList(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            return UserAccountDB.GetOfflineList(userAccountID, userName, password, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            return UserAccountDB.GetDataTable(userAccountID, userName, password, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid userAccountID, string userName, string password, string keyword, DateTime fromDate, DateTime toDate)
        {
            return UserAccountDB.GetDataSet(userAccountID, userName, password, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(UserAccount myUser)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                UserAccountDB.Save(myUser);

                myTransactionScope.Complete();
                return true;
            }
        }

        public static bool Delete(Guid UserAccID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                UserAccountDB.Delete(UserAccID);
                myTransactionScope.Complete();
            return true;
            }
        }

        public static void DeleteLocal()
        {
            UserAccountDB.DeleteLocal();
        }
    }
}
